' ToolForm.vb
'
' This file implements the Form window that is the
' user interface for the simple Tool plug-in that this
' project creates. The Form contains two buttons. One button
' disables all LA modules in the system. The other enables
' all LA modules
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Imports Tektronix.LogicAnalyzer.PlugIn
Imports Tektronix.LogicAnalyzer.TpiNet
Imports System
Imports System.Windows.Forms
Imports System.Collections

Namespace VBSamplePlugIn

    ' To ensure the best interaction with the TLA user interface,
    ' this class is derived from TlaForm.
    Public Class ToolForm
        Inherits TlaForm

        Dim plugInSupport As ITlaPlugInSupport

#Region " Windows Form Designer generated code "

        Public Sub New(ByVal support As ITlaPlugInSupport)
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call
            plugInSupport = support
        End Sub

        'Form overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents disableButton As System.Windows.Forms.Button
        Friend WithEvents enableButton As System.Windows.Forms.Button
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(ToolForm))
            Me.disableButton = New System.Windows.Forms.Button()
            Me.enableButton = New System.Windows.Forms.Button()
            Me.SuspendLayout()
            '
            'disableButton
            '
            Me.disableButton.Location = New System.Drawing.Point(32, 24)
            Me.disableButton.Name = "disableButton"
            Me.disableButton.Size = New System.Drawing.Size(280, 48)
            Me.disableButton.TabIndex = 0
            Me.disableButton.Text = "Disable All LA Modules"
            '
            'enableButton
            '
            Me.enableButton.Location = New System.Drawing.Point(32, 96)
            Me.enableButton.Name = "enableButton"
            Me.enableButton.Size = New System.Drawing.Size(280, 48)
            Me.enableButton.TabIndex = 1
            Me.enableButton.Text = "Enable All LA Modules"
            '
            'ToolForm
            '
            Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
            Me.ClientSize = New System.Drawing.Size(344, 176)
            Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.enableButton, Me.disableButton})
            Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
            Me.Name = "ToolForm"
            Me.Text = "Example Tool Plug-In"
            Me.ResumeLayout(False)

        End Sub

#End Region

        ' Disables all LA modules in the system in response to
        ' user pressing the disableButton button.
        Private Sub disableButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles disableButton.Click
            SetLAsEnabledState(False)
        End Sub

        ' Enables all LA modules in the system in response to
        ' user pressing the m_enableLAsButton button.
        Private Sub enableButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles enableButton.Click
            SetLAsEnabledState(True)
        End Sub

        ' This utility method uses the cached ITlaPlugInSupport object
        ' to find all LA modules and set their enabled state.
        Private Sub SetLAsEnabledState(ByVal enabledState As Boolean)
            If Not Nothing Is plugInSupport Then
                Dim dataSources As ArrayList
                Dim i As Integer

                ' The ITlaSystem::DataSources property contains a list
                ' of all data sources in the system
                dataSources = plugInSupport.System.DataSources

                ' Search through the list for ILAModule instances
                ' and changed their enabled state.
                For i = 0 To dataSources.Count - 1
                    If TypeOf dataSources(i) Is ILAModule Then
                        Dim laModule As ILAModule
                        laModule = dataSources(i)
                        laModule.IsEnabled = enabledState
                    End If
                Next i
            End If
        End Sub
    End Class
End Namespace
